const express = require('express');
const router = express.Router();
const projectController  = require('../controllers/projects');

// Get all items
router.get('/projects', projectController.getProjects);
router.get('/projects/:id', projectController.getSingleProject);
router.get('/luxuryProjects', projectController.getLuxuryProjects)
router.get('/currentFeaturedProjects', projectController.getCurentFeaturedProjects)
router.get('/projectsByDType/:type', projectController.getProjectsByDType);
router.get('/projectsByPType/:type', projectController.getProjectsByPType);
router.get('/projectsBylocation/:location', projectController.getProjectsByLocation);

router.post('/projects', projectController.createProject);
router.put('/projects/:id', projectController.updateProject);
router.delete('/projects/:id', projectController.deleteProject);

module.exports = router;


