const express = require('express');
const router = express.Router();
const ourStoryController  = require('../controllers/ourStory');

// Get all items
router.get('/story', ourStoryController.getOurStory);
router.get('/story/:id', ourStoryController.getSingleOurStory);
router.post('/story', ourStoryController.createOurStory);
router.put('/story/:id', ourStoryController.editOurStory);
router.delete('/story/:id', ourStoryController.deleteOurStory);

module.exports = router;
