const express = require('express');
const router = express.Router();
const newsController  = require('../controllers/news');

// Get all items
router.get('/news', newsController.getNews);
router.get('/news/:id', newsController.getSingleNews);
router.post('/news', newsController.createNews);
router.put('/news/:id', newsController.editNews);
router.delete('/news/:id', newsController.deleteNews);

module.exports = router;
