const express = require("express");


const {
  getCategories,
  getCategoryById,
  getSubCategories,
  updateCategory,
  addCategory,
  deleteCategory,
} = require("../controllers/category");

const {
  getItems,
  getItembyID,
  getFeaturedItemsByOutletID,
  addItem,
  updateItem,
  deleteItem,
  updateAvailabilityStatus,
} = require("../controllers/item");

const router = express.Router();


// router.get("/food/:outletID", getFoodByOutlet);

router.get("/item", getItems);
router.get("/item/:id", getItembyID);
router.post("/item", addItem);
router.put("/item", updateItem);
router.delete("/item", deleteItem);
router.put("/item-status", updateAvailabilityStatus);

router.get("/category", getCategories);
router.get("/category/:id", getCategoryById);
router.get("/sub-category", getSubCategories);
router.post("/category", addCategory);
router.put("/category", updateCategory);
router.delete("/category", deleteCategory);

module.exports = router;
