const express = require('express');
const router = express.Router();
const materialsController  = require('../controllers/materials');

// Get all green
router.get('/materials', materialsController.getMaterials);
router.get('/materials/:id', materialsController.getSingleMaterials);
router.post('/materials', materialsController.createMaterials);
router.put('/materials/:id', materialsController.editMaterials);
router.delete('/materials/:id', materialsController.deleteMaterials);

module.exports = router;
