const express = require('express');
const router = express.Router();
const locatoinController  = require('../controllers/location');

// Get all items
router.get('/location', locatoinController.getLocations);
router.get('/location/child', locatoinController.getChiledLocations);
router.get('/location/parent', locatoinController.getParentLocations);
router.get('/location/:id', locatoinController.getSingleLocation);
// pid=parent Id , pname = parent name 
router.get('/locationbyPid/:Pid', locatoinController.getLocationByParentId);
router.get('/locationbyPname/:Pname', locatoinController.getChildLocationsByParentName);
router.post('/location', locatoinController.createLocation);
router.put('/location/:id', locatoinController.editLocation);
router.delete('/location/:id', locatoinController.deleteLocation);

module.exports = router;
