const express = require('express');
const router = express.Router();
const reviewController  = require('../controllers/landownerReview');

// Get all items
router.get('/landownerReview', reviewController.getReviews);
router.get('/landownerReview/:id', reviewController.getSingleReview);
router.post('/landownerReview', reviewController.createReviews);
router.put('/landownerReview/:id', reviewController.editReviews);
router.delete('/landownerReview/:id', reviewController.deleteReviews);

module.exports = router;


