const express = require('express');
const router = express.Router();
const newsController  = require('../controllers/directors');

// Get all items
router.get('/director', newsController.getDirectors);
router.get('/director/:id', newsController.getSingleDirectors);
router.post('/director', newsController.createDirectors);
router.put('/director/:id', newsController.editDirectors);
router.delete('/director/:id', newsController.deleteDirectors);

module.exports = router;
