const express = require("express");
const multer = require("multer");
const nodemailer = require("nodemailer");
const router = express.Router();

// Upload cv and send to email
const transporter = nodemailer.createTransport({
  service: "Gmail",
  secure: false, 
  auth: {
    user: process.env.GMAIL,
    pass: process.env.GMAIL_PASS,
  },
});

// Verify connection configuration
//comment out to dont see the wanning, but code is ok

// transporter.verify(function (error, success) {
//   if (error) {
//     console.log(error);
//   } else {
//     console.log("Server is ready to take our messages");
//   }
// });

const upload = multer();
const filesUpload = upload.fields([{ name: "cv", maxCount: 1 }]);

// Handle file upload
router.post("/cv", filesUpload, (req, res) => {
  if (!req.files || !req.files.cv) {
    return res.status(400).json({ error: "File not found" });
  }

  const cvFile = req.files.cv[0];

  // Get form data from the request body
  const { name, email, phone } = req.body;

  //console.log("cvFile===>>", cvFile);

  // Compose the email
  const mailOptions = {
    from: "mthcreativeworld@gmail.com",
    to: "navanafoods.bd@gmail.com",
    subject: "New Resume Submission",
    text: "Email content",
    html: `
      <h3>New Resume Submission</h3>
      <p><strong>Name:</strong> ${name}</p>
      <p><strong>Email:</strong> ${email}</p>
      <p><strong>Phone Number:</strong> ${phone}</p>
    `,
    attachments: [
      {
        filename: cvFile.originalname,
        content: cvFile.buffer,
      },
    ],
  };

  // Send the email
  transporter.sendMail(mailOptions, (error, info) => {
    if (error) {
      console.error("Error sending email:", error);
      return res.status(500).json({ error: "Failed to send email" });
    }
    console.log("Email sent:", info.messageId);
    return res
      .status(200)
      .json({ message: "File uploaded and email sent successfully" });
  });
});

module.exports = router;
