const express = require('express');
const router = express.Router();
const contactInfoController  = require('../controllers/contactInfo');

// Get all items
router.get('/contactInfo', contactInfoController.getContactInfo);
router.post('/contactInfo', contactInfoController.createContactInfo);
router.put('/contactInfo', contactInfoController.editContactInfo);
router.delete('/contactInfo', contactInfoController.deleteContactInfo);

router.post('/sendEmail', contactInfoController.sendEmail)
router.get('/formData', contactInfoController.getFromData)
router.delete('/formData/:id', contactInfoController.deleteSingleFormData)

module.exports = router;
