const express = require('express');
const router = express.Router();
const reviewController  = require('../controllers/clientsReview');

// Get all items
router.get('/review', reviewController.getReviews);
router.get('/review/:id', reviewController.getSingleReview);
router.post('/review', reviewController.createReviews);
router.put('/review/:id', reviewController.editReviews);
router.delete('/review/:id', reviewController.deleteReviews);

module.exports = router;


