const express = require('express');
const router = express.Router();
const clientController  = require('../controllers/clients');

// Get all items
router.get('/clients', clientController.getClients);
router.get('/clients/:id', clientController.getSingleClient);
router.post('/clients', clientController.createClient);
router.put('/clients/:id', clientController.editClient);
router.delete('/clients/:id', clientController.deleteClient);

module.exports = router;
