const express = require("express");
const cors = require('cors');
const {
  getAdmins,
  getSingleAdmin,
  createAdmin,
  deleteAdminById,
  login,
  AdminLogin,
  logout,
  admin,
} = require("../controllers/auth");

const auth = require("../middlewears/auth");

const router = express.Router();

router.get("/admin", getAdmins);
router.get("/admin/:id", getSingleAdmin);
router.post("/admin", createAdmin);
router.post("/login", login);
// router.post("/admin/auth", AdminLogin);
router.get("/logout", logout);
// router.get("/admin",admin);

module.exports = router;
