const User = require("../models/user");
const jwt = require("jsonwebtoken");
const { hashPassword, comparePassword } = require("../utils/auth");

// Endpoint to send OTP to the user's mobile number
exports.sendOtp = async (req, res) => {
  try {
    const number = req.body.number;
console.log("req.body.number=>", number)
    // Generate a time-based OTP
    const secret = speakeasy.generateSecret({ length: 6 });
    console.log("secret=>", number)

    const otp = speakeasy.totp({
      secret: secret.base32,
      encoding: 'base32',
    });

    console.log("generated=>", otp)

    // Store the OTP in the temporary storage
    //import database model and store this opt with number
    otpStorage = otp;

    // TODO: Add code to send the OTP via SMS using SSL Commerce 
    // Placeholder for the code to send the OTP via SMS
    // sendOtpViaSms(number, otp);

    // Response indicating success
    res.json({ success: true });
  } catch (err) {
    console.error(err);
    res.status(500).json({ success: false, error: 'Error sending OTP' });
  }
};

// Endpoint to verify the received OTP
exports.verifyOtp = async (req, res) => {
  const { mobileNumber, otp } = req.body;

  // Validate the received OTP
  const secret = ''; // Retrieve the secret for the user based on mobileNumber
  const isValid = speakeasy.totp.verify({
    secret: secret,
    encoding: 'base32',
    token: otp,
  });

  if (isValid) {
    // Authentication logic here
    res.json({ success: true, message: 'OTP verified successfully' });
  } else {
    res.status(401).json({ success: false, error: 'Invalid OTP' });
  }
};
