// controllers/news.js
exports.getTeam = (req, res) => {
  const db = req.db;
  const selectQuery = 'SELECT * FROM team';

  db.query(selectQuery, (err, results) => {
    if (results?.length === 0) {
      return res.status(404).json({ message: 'No data found.' });
    }
    if (err) {
      console.error('Error retrieving team:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }
    const parsedResult = results.map(p => {
      p.imgUrls = JSON.parse(p.imgUrls)
      return p
    })

    res.status(200).json(parsedResult);
  });
};

exports.createTeam = (req, res) => {
  const { title, imgUrls, description } = req.body;

  if (!title) {
    return res.status(400).json({ error: 'team Title required' });
  }

  const db = req.db;
  const insertQuery = 'INSERT INTO team (title, imgUrls, description) VALUES (?, ?, ?)';
  const values = [title,JSON.stringify(imgUrls), description];
  console.log("value::", values);
  db.query(insertQuery, values, (err, result) => {
    if (err) {
      console.error('Error creating team:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }
    res.status(201).json({ message: 'team created successfully', news: result.insertId });
  });
};

exports.editTeam = (req, res) => {
  const db = req.db;
  const { title, imgUrls, description } = req.body;

  if (!title) {
    return res.status(400).json({ error: 'Title is required' });
  }

  const updateQuery = 'UPDATE team SET title = ?, imgUrls = ?, description = ?';
  const values = [title, JSON.stringify(imgUrls), description];

  db.query(updateQuery, values, (err, result) => {
    if (err) {
      console.error('Error editing team:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    res.status(200).json({ message: 'Team edited successfully' }); 
  });
};

