// controllers/projects.js
exports.getProjects = (req, res) => {
  const db = req.db;
  const selectQuery = 'SELECT * FROM projects ORDER BY orderby DESC';

  db.query(selectQuery, (err, results) => {
    if (results?.length === 0) {
      return res.status(404).json({ message: 'No data found.' });
    }
    if (err) {
      console.error('Error retrieving projects:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    // Parse each project's fields
    const parsedResult = results.map(p => {
      p.imagesName = JSON.parse(p.imagesName)
      p.florePlanImgs = JSON.parse(p.florePlanImgs)
      p.feature = JSON.parse(p.feature)
      p.amenities = JSON.parse(p.amenities)
      p.map = JSON.parse(p.map)
      return p;

    })

    res.status(200).json(parsedResult);
  });
};

exports.getLuxuryProjects = (req, res) => {
  const db = req.db;

  const selectQuery = `SELECT * FROM projects WHERE isLuxury IS NOT NULL AND isLuxury != 0 ORDER BY isLuxury DESC;`;

  db.query(selectQuery, (err, results) => {
    if (results?.length === 0) {
      return res.status(404).json({ message: 'No data found.' });
    }
    if (err) {
      console.error('Error retrieving projects:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    // Parse each project's fields
    const parsedResult = results.map(p => {
      p.imagesName = JSON.parse(p.imagesName)
      p.florePlanImgs = JSON.parse(p.florePlanImgs)
      p.feature = JSON.parse(p.feature)
      p.amenities = JSON.parse(p.amenities)
      p.map = JSON.parse(p.map)

      return p;

    })

    res.status(200).json(parsedResult);
  });
}

exports.getCurentFeaturedProjects = (req, res) => {
  const db = req.db;

  const selectQuery = `SELECT * FROM projects WHERE isCurrentFeatured IS NOT NULL AND isCurrentFeatured != 0 ORDER BY isCurrentFeatured DESC`;

  db.query(selectQuery, (err, results) => {
    if (results?.length === 0) {
      return res.status(404).json({ message: 'No data found.' });
    }
    if (err) {
      console.error('Error retrieving projects:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    // Parse each project's fields
    const parsedResult = results.map(p => {
      p.imagesName = JSON.parse(p.imagesName)
      p.florePlanImgs = JSON.parse(p.florePlanImgs)
      p.feature = JSON.parse(p.feature)
      p.amenities = JSON.parse(p.amenities)
      p.map = JSON.parse(p.map)

      return p;

    })

    res.status(200).json(parsedResult);
  });
}

exports.getProjectsByLocation = (req, res) => {
  const db = req.db;
  const location = req.params.location;
  const selectQuery = 'SELECT * FROM projects WHERE location = ? ORDER BY orderby DESC';
  const value = [location]
  db.query(selectQuery, value, (err, results) => {
    if (results?.length === 0) {
      return res.status(404).json({ message: 'No data found.' });
    }
    if (err) {
      console.error('Error retrieving projects:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    // Parse each project's fields
    const parsedResult = results.map(p => {
      p.imagesName = JSON.parse(p.imagesName)
      p.florePlanImgs = JSON.parse(p.florePlanImgs)
      p.feature = JSON.parse(p.feature)
      p.amenities = JSON.parse(p.amenities)
      p.map = JSON.parse(p.map)

      return p;

    })

    res.status(200).json(parsedResult);
  });
};

exports.getProjectsByDType = (req, res) => {
  const db = req.db;
  const type = req.params.type;
  const selectQuery = 'SELECT * FROM projects WHERE developmentType = ? ORDER BY orderby DESC';  //table name 'projects'
  const value = [type]

  db.query(selectQuery, value, (err, results) => {
    if (results?.length === 0) {
      return res.status(404).json({ message: 'No data found.' });
    }
    if (err) {
      console.error('Error retrieving projects:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    // Parse each project's fields
    const parsedResult = results.map(p => {
      p.imagesName = JSON.parse(p.imagesName)
      p.florePlanImgs = JSON.parse(p.florePlanImgs)
      p.feature = JSON.parse(p.feature)
      p.amenities = JSON.parse(p.amenities)
      p.map = JSON.parse(p.map)

      return p;

    })

    res.status(200).json(parsedResult);
  });
};

exports.getProjectsByPType = (req, res) => {
  const db = req.db;
  const type = req.params.type;
  const selectQuery = 'SELECT * FROM projects WHERE propertyType = ? ORDER BY orderby DESC';
  const value = [type]

  db.query(selectQuery, value, (err, results) => {
    if (results?.length === 0) {
      return res.status(404).json({ message: 'No data found.' });
    }
    if (err) {
      console.error('Error retrieving projects:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    // Parse each project's fields
    const parsedResult = results.map(p => {
      p.imagesName = JSON.parse(p.imagesName)
      p.florePlanImgs = JSON.parse(p.florePlanImgs)
      p.feature = JSON.parse(p.feature)
      p.amenities = JSON.parse(p.amenities)
      p.map = JSON.parse(p.map)

      return p;

    })

    res.status(200).json(parsedResult);
  });
};
// controllers/projects.js
exports.getSingleProject = (req, res) => {
  const db = req.db;
  const projectId = req.params.id;
  console.log("projectId >>", projectId);
  const selectQuery = 'SELECT * FROM projects WHERE projectId = ?';
  const values = [projectId];

  db.query(selectQuery, values, (err, results) => {
    if (err) {
      console.error('Error retrieving project:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (results.length === 0) {
      return res.status(404).json({ message: 'Project not found.' });
    }

    const project = results[0];

    // Parse the back to an array
    project.imagesName = JSON.parse(project.imagesName);
    project.florePlanImgs = JSON.parse(project.florePlanImgs);
    project.feature = JSON.parse(project.feature);
    project.amenities = JSON.parse(project.amenities);
    project.map = JSON.parse(project.map);

    res.status(200).json(project);
  });
};

exports.createProject = (req, res) => {
  const {
    name,
    description,
    developmentType,
    propertyType,
    location,
    buildingHeight,
    noOfApartment,
    facing,
    landSize,
    noOfCarParking,
    apartmentSize,
    unitPerFloor,
    apartmentArrangement,
    noOfLifts,
    imagesName,
    florePlanImgs,
    imageName,
    image2Name,
    brochureName,
    map,
    address,
    feature,
    amenities
  } = req.body;

  if (!name) {
    return res.status(400).json({ error: 'Name is required' });
  }

  const db = req.db;
  const insertQuery = `
  INSERT INTO projects (
  slug,
    name,
    description,
    developmentType,
    propertyType,
    location,
    buildingHeight,
    noOfApartment,
    facing,
    landSize,
    noOfCarParking,
    apartmentSize,
    unitPerFloor,
    apartmentArrangement,
    noOfLifts,
    address,
    brochureName,
    imageName,
    image2Name,
    imagesName,
    florePlanImgs,
    feature,
    amenities,
    map
  ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`;

  const slug = createSlug(name)

  const values = [
    slug,
    name,
    description,
    developmentType,
    propertyType,
    location,
    buildingHeight,
    noOfApartment,
    facing,
    landSize,
    noOfCarParking,
    apartmentSize,
    unitPerFloor,
    apartmentArrangement,
    noOfLifts,
    address,
    brochureName,
    imageName,
    image2Name,
    JSON.stringify(imagesName),
    JSON.stringify(florePlanImgs),
    // ["image2.jpg", "image3.jpg"], 
    JSON.stringify(feature),
    JSON.stringify(amenities),
    JSON.stringify(map)
  ];

  db.query(insertQuery, values, (err, result) => {
    if (err) {
      console.error('Error creating project:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }
    res.status(200).json({ message: 'Project created successfully', projectId: result.insertId });
  });
};

// Function to create a slug from the title (you can replace this with your own implementation)
function createSlug(title) {
  // Implement your slug generation logic here
  // Example: Remove special characters, replace spaces with hyphens, etc.
  return title.toLowerCase().replace(/\s+/g, '-');
}

exports.updateProject = (req, res) => {
  const {
    projectId,
    orderby,
    slug,
    name,
    description,
    developmentType,
    propertyType,
    location,
    buildingHeight,
    noOfApartment,
    facing,
    landSize,
    noOfCarParking,
    apartmentSize,
    unitPerFloor,
    apartmentArrangement,
    noOfLifts,
    imagesName,
    florePlanImgs,
    imageName,
    image2Name,
    brochureName,
    map,
    address,
    feature,
    amenities,
    isLuxury,
    isCurrentFeatured
  } = req.body;

  if (!projectId) {
    return res.status(400).json({ error: 'Project ID is required' });
  }

  const db = req.db;
  const updateQuery = `
    UPDATE projects 
    SET 
      slug = ?,
      name = ?,
      orderby = ?,
      description = ?,
      developmentType = ?,
      propertyType = ?,
    location = ?,
      buildingHeight = ?,
      noOfApartment = ?,
      facing = ?,
      landSize = ?,
      noOfCarParking = ?,
      apartmentSize = ?,
      unitPerFloor = ?,
      apartmentArrangement = ?,
      noOfLifts = ?,
      address = ?,
      brochureName = ?,
      imageName = ?,
      image2Name = ?,
      imagesName = ?,
      florePlanImgs = ?,
      feature = ?,
      amenities = ?,
      map = ?,
      isLuxury = ?,
      isCurrentFeatured = ?
    WHERE projectId = ?`;

  const values = [
    slug,
    name,
    orderby,
    description,
    developmentType,
    propertyType,
    location,
    buildingHeight,
    noOfApartment,
    facing,
    landSize,
    noOfCarParking,
    apartmentSize,
    unitPerFloor,
    apartmentArrangement,
    noOfLifts,
    address,
    brochureName,
    imageName,
    image2Name,
    JSON.stringify(imagesName),
    JSON.stringify(florePlanImgs),
    JSON.stringify(feature),
    JSON.stringify(amenities),
    JSON.stringify(map),
    isLuxury,
    isCurrentFeatured,
    projectId
  ];

  db.query(updateQuery, values, (err, result) => {
    if (err) {
      console.error('Error updating project:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }
    if (result.affectedRows === 0) {
      return res.status(404).json({ error: 'Project not found' });
    }
    res.status(200).json({ message: 'Project updated successfully' });
  });
};

// delete projects by ID
exports.deleteProject = (req, res) => {
  const db = req.db;
  const projectId = req.params.id;

  const deleteQuery = 'DELETE FROM projects WHERE projectId = ?';
  const values = [projectId];

  db.query(deleteQuery, values, (err, result) => {
    if (err) {
      console.error('Error deleting project:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (result.affectedRows === 0) {
      return res.status(404).json({ message: 'Project not found.' });
    }

    res.status(200).json({ message: 'Project deleted successfully' });
  });
};
