// controllers/csrgallery.js
exports.getOurStory = (req, res) => {
  const db = req.db;
  const selectQuery = 'SELECT * FROM ourstory';

  db.query(selectQuery, (err, results) => {
    if (results?.length === 0) {
      return res.status(404).json({ message: 'No data found.' });
    }

    if (err) {
      console.error('Error retrieving ourstory:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    // const parsedResult = results.map(n => {
    //   n.imageUrls = JSON.parse(n.imageUrls)
    //   return n;
    // })

    res.status(200).json(results);
  });
};

exports.getSingleOurStory = (req, res) => {
  const db = req.db;
  const ourstoryId = req.params.id;
  const selectQuery = 'SELECT * FROM ourstory WHERE id = ?';
  const values = [ourstoryId];

  db.query(selectQuery, values, (err, results) => {
    if (err) {
      console.error('Error retrieving ourstory:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (results.length === 0) {
      return res.status(404).json({ message: 'ourstory not found.' });
    }

    // const parsedResult = results.map(n => {
    //   n.imageUrls = JSON.parse(n.imageUrls)
    //   return n;
    // })

    // const csrgallery = parsedResult[0];
    res.status(200).json(results);
  });
};

exports.createOurStory = (req, res) => {
  const {title, imgUrl, description} = req.body;

  if (!title) {
    return res.status(400).json({ error: 'ourstory Title required' });
  }

  const db = req.db;
  const insertQuery = 'INSERT INTO ourstory (title, imgUrl, description) VALUES (?, ?, ?)';
  const values = [
    title,
    imgUrl,
    description,
  ];
  console.log("value::", values);
  db.query(insertQuery, values, (err, result) => {
    if (err) {
      console.error('Error creating csrgallery:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }
    res.status(201).json({ message: 'csrgallery created successfully', csrgallery: result.insertId });
  });
};

exports.editOurStory = (req, res) => {
  const db = req.db;
  const id = req.params.id;
  const { title, imgUrl, description } = req.body;

  if (!title) {
    return res.status(400).json({ error: 'Location name required' });
  }

  const updateQuery = 'UPDATE ourstory SET title = ?, imgUrl = ?, description = ? WHERE id = ? ';
  const values = [title, imgUrl, description, id];

  db.query(updateQuery, values, (err, result) => {
    if (err) {
      console.error('Error editing csrgallery:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (result.affectedRows === 0) {
      return res.status(404).json({ message: 'csrgallery not found.' });
    }
    res.status(200).json({ message: 'csrgallery edited successfully' });
  });
};

exports.deleteOurStory = (req, res) => {
  const db = req.db;
  const id = req.params.id;

  const deleteQuery = 'DELETE FROM ourstory WHERE id = ?';
  const values = [id];

  db.query(deleteQuery, values, (err, result) => {
    if (err) {
      console.error('Error deleting csrgallery:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (result.affectedRows === 0) {
      return res.status(404).json({ message: 'csrgallery not found.' });
    }

    res.status(200).json({ message: 'csrgallery deleted successfully' });
  });
};

