// controllers/otherinfo.js
exports.getOtherInfo = (req, res) => {
    const db = req.db;
    const selectQuery = 'SELECT * FROM otherinfo';
  
    db.query(selectQuery, (err, results) => {
      if (results?.length === 0) {
        return res.status(404).json({ message: 'No otherinfo data found.' });
      }
      if (err) {
        console.error('Error retrieving otherinfo:', err);
        return res.status(500).json({ error: 'Internal Server Error' });
      }
  
      // Parse JSON fields (ourstory in this case)
      const parsedResult = results.map(row => {
        try {
          row.ourstory = JSON.parse(row.ourstory);
        } catch (parseError) {
          console.error('Error parsing ourstory:', parseError);
          row.ourstory = []; // Or a default value if parsing fails
        }
        return row;
      });
  
      res.status(200).json(parsedResult[0]); // Since it's a single row, send the first item
    });
  };

  exports.createOtherInfo = (req, res) => {
    const db = req.db;
    const { 
      qualitytext, qualityimg, globaltext, blobalimg, certificatetext,
      certificateimg, mission, vision, ourstory, headerlogourl, footerlogourl
    } = req.body;
  
    // Validation (More thorough validation is recommended)
    if (!qualitytext || !globaltext || !certificatetext) {
      return res.status(400).json({ error: 'Required fields are missing' });
    }
  
    // Check if a row already exists
    db.query('SELECT * FROM otherinfo', (err, existingResults) => {
      if (err) {
        console.error('Error checking for existing otherinfo:', err);
        return res.status(500).json({ error: 'Internal Server Error' });
      }
  
      if (existingResults.length > 0) {
        // Row already exists, you might want to handle this differently (e.g., update or error)
        return res.status(409).json({ error: 'Otherinfo data already exists. Use PUT to update.' });
      } else {
        // No existing row, proceed with insertion
        const insertQuery = `
          INSERT INTO otherinfo (qualitytext, qualityimg, globaltext, blobalimg, certificatetext, 
                                certificateimg, mission, vision, ourstory, headerlogourl, footerlogourl)
          VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        `;
  
        const values = [
          qualitytext, qualityimg, globaltext, blobalimg, certificatetext,
          certificateimg, mission, vision, JSON.stringify(ourstory), headerlogourl, footerlogourl
        ];
  
        db.query(insertQuery, values, (err, result) => {
          if (err) {
            console.error('Error creating otherinfo:', err);
            return res.status(500).json({ error: 'Internal Server Error' });
          }
          res.status(201).json({ message: 'Otherinfo created successfully' });
        });
      }
    });
  };
  
  exports.updateOtherInfo = (req, res) => {
    const db = req.db;
    const { 
      qualitytext, qualityimg, globaltext, blobalimg, certificatetext,
      certificateimg, mission, vision, ourstory, headerlogourl, footerlogourl
    } = req.body;
  
    // Validation (You can add more specific validation as needed)
    if (!qualitytext || !globaltext || !certificatetext) {
      return res.status(400).json({ error: 'Required fields are missing' });
    }
  
    const updateQuery = `
      UPDATE otherinfo 
      SET 
        qualitytext = ?, qualityimg = ?, globaltext = ?, blobalimg = ?, 
        certificatetext = ?, certificateimg = ?, mission = ?, vision = ?, 
        ourstory = ?, headerlogourl = ?, footerlogourl = ?
    `;
  
    const values = [
      qualitytext, qualityimg, globaltext, blobalimg, certificatetext,
      certificateimg, mission, vision, JSON.stringify(ourstory), headerlogourl, footerlogourl
    ];
  
    db.query(updateQuery, values, (err, result) => {
      if (err) {
        console.error('Error updating otherinfo:', err);
        return res.status(500).json({ error: 'Internal Server Error' });
      }
      res.status(200).json({ message: 'Otherinfo updated successfully' });
    });
  };
  
// controllers/otherinfo.js (continued...)

