// controllers/news.js
exports.getNews = (req, res) => {
  const db = req.db;
  const selectQuery = 'SELECT * FROM news ORDER BY orderby DESC ';

  db.query(selectQuery, (err, results) => {
    if (results?.length === 0) {
      return res.status(404).json({ message: 'No data found.' });
    }

    if (err) {
      console.error('Error retrieving news:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    const parsedResult = results.map(n => {
      n.imageUrls = JSON.parse(n.imageUrls)
      return n;
    })

    res.status(200).json(parsedResult);
  });
};

exports.getSingleNews = (req, res) => {
  const db = req.db;
  const newsId = req.params.id;
  const selectQuery = 'SELECT * FROM news WHERE newsId = ?';
  const values = [newsId];

  db.query(selectQuery, values, (err, results) => {
    if (err) {
      console.error('Error retrieving news:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (results.length === 0) {
      return res.status(404).json({ message: 'News not found.' });
    }

    const parsedResult = results.map(n => {
      n.imageUrls = JSON.parse(n.imageUrls)
      return n;
    })

    const news = parsedResult[0];
    res.status(200).json(news);
  });
};

exports.createNews = (req, res) => {
  const {title, imageUrl, des, imageUrls} = req.body;

  if (!title) {
    return res.status(400).json({ error: 'News Title required' });
  }

  const db = req.db;
  const insertQuery = 'INSERT INTO news (title, imageUrl, des, imageUrls, slug) VALUES (?, ?, ?, ?, ?)';
  const slug = createSlug(title)
  const values = [
    title,
    imageUrl,
    des,
    JSON.stringify(imageUrls),
    slug

  ];
  console.log("value::", values);
  db.query(insertQuery, values, (err, result) => {
    if (err) {
      console.error('Error creating news:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }
    res.status(201).json({ message: 'news created successfully', news: result.insertId });
  });
};

//create slug function
function createSlug(title) {
  // Remove special characters and spaces
  const slug = title.replace(/[^\w\s-]/g, '').trim().toLowerCase();
  // Replace spaces with hyphens
  return slug.replace(/\s+/g, '-');
}

exports.editNews = (req, res) => {
  const db = req.db;
  const newsId = req.params.id;
  const { title, orderby, imageUrl, des, imageUrls, slug } = req.body;

  if (!title) {
    return res.status(400).json({ error: 'Location name required' });
  }

  const updateQuery = 'UPDATE news SET title = ?, orderby = ?, imageUrl = ?, des = ?, imageUrls = ?, slug = ? WHERE newsId = ?';
  const values = [title, orderby, imageUrl, des, JSON.stringify(imageUrls), slug, newsId];

  db.query(updateQuery, values, (err, result) => {
    if (err) {
      console.error('Error editing news:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (result.affectedRows === 0) {
      return res.status(404).json({ message: 'news not found.' });
    }
    res.status(200).json({ message: 'news edited successfully' });
  });
};

exports.deleteNews = (req, res) => {
  const db = req.db;
  const newsId = req.params.id;

  const deleteQuery = 'DELETE FROM news WHERE newsId = ?';
  const values = [newsId];

  db.query(deleteQuery, values, (err, result) => {
    if (err) {
      console.error('Error deleting news:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (result.affectedRows === 0) {
      return res.status(404).json({ message: 'news not found.' });
    }

    res.status(200).json({ message: 'news deleted successfully' });
  });
};

