// controllers/materials.js
exports.getMaterials = (req, res) => {
  const db = req.db;
  const selectQuery = 'SELECT * FROM materials';

  db.query(selectQuery, (err, results) => {
    if (results?.length === 0) {
      return res.status(404).json({ message: 'No data found.' });
    }
    if (err) {
      console.error('Error retrieving materials concepts:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    res.status(200).json(results);
  });
};

exports.getSingleMaterials = (req, res) => {
  const db = req.db;
  const greenId = req.params.id;
  const selectQuery = 'SELECT * FROM materials WHERE id = ?';
  const values = [greenId];

  db.query(selectQuery, values, (err, results) => {
    if (err) {
      console.error('Error retrieving materials:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (results.length === 0) {
      return res.status(404).json({ message: 'materials  not found.' });
    }

    const reviews = results[0];
    res.status(200).json(reviews);
  });
};

exports.createMaterials = (req, res) => {
  const { name, details } = req.body;

  if (!name) {
    return res.status(400).json({ error: 'materials name required' });
  }

  const db = req.db;
  const insertQuery = 'INSERT INTO materials (name, details) VALUES (?, ?)';
  const values = [name, details];
console.log("value::", values);
  db.query(insertQuery, values, (err, result) => {
    if (err) {
      console.error('Error creating materials:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }
    res.status(201).json({ message: 'materials created successfully', materials: result.insertId });
  });
};

exports.editMaterials = (req, res) => {
  const db = req.db;
  const materialsId = req.params.id;
  const {name, details } = req.body;

  if (!name) {
      return res.status(400).json({ error: 'materials preactice name required' });
  }

  const updateQuery = 'UPDATE materials SET name = ?, details = ? WHERE id = ?';
  const values = [name, details, materialsId];

  db.query(updateQuery, values, (err, result) => {
      if (err) {
          console.error('Error editing materials:', err);
          return res.status(500).json({ error: 'Internal Server Error' });
      }

      if (result.affectedRows === 0) {
          return res.status(404).json({ message: 'materials not found.' });
      }
      res.status(200).json({ message: 'materials edited successfully' });
  });
};
 
exports.deleteMaterials = (req, res) => {
  const db = req.db;
  const materialsId = req.params.id;

  const deleteQuery = 'DELETE FROM materials WHERE id = ?';
  const values = [materialsId];

  db.query(deleteQuery, values, (err, result) => {
    if (err) {
      console.error('Error deleting materials:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (result.affectedRows === 0) {
      return res.status(404).json({ message: 'materials not found.' });
    }

    res.status(200).json({ message: 'materials deleted successfully' });
  });
};

