// controllers/locations.js
exports.getLocations = (req, res) => {
  const db = req.db;
  const selectQuery = 'SELECT * FROM locations ORDER BY orderby DESC';

  db.query(selectQuery, (err, results) => {
    if (results?.length === 0) {
      return res.status(404).json({ message: 'No data found.' });
    }
    if (err) {
      console.error('Error retrieving locations:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    res.status(200).json(results);
  });
};

exports.getChiledLocations = (req, res) => {
  const db = req.db;
  const selectQuery = 'SELECT * FROM locations WHERE parentid IS NOT NULL ORDER BY orderby DESC';

  db.query(selectQuery, (err, results) => {
    if (results?.length === 0) {
      return res.status(404).json({ message: 'No data found.' });
    }
    if (err) {
      console.error('Error retrieving locations:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    res.status(200).json(results);
  });
};

exports.getSingleLocation = (req, res) => {
  const db = req.db;
  const locationId = req.params.id;
  const selectQuery = 'SELECT * FROM locations WHERE locationId = ?';
  const values = [locationId];

  db.query(selectQuery, values, (err, results) => {

    if (err) {
      console.error('Error retrieving location:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (results.length === 0) {
      return res.status(404).json({ message: 'Location not found.' });
    }

    const location = results[0];
    res.status(200).json(location);
  });
};

exports.getLocationByParentId = (req, res) => {
const db = req.db;
const parentId = req.params.Pid
const selectQuery = 'SELECT * FROM locations WHERE parentId = ? ORDER BY orderby DESC'
const values = [parentId]

db.query(selectQuery, values, (err, results) => {
  if (err) {
    console.error("Error retrieving location", err);
    return res.status(500).josn({message: "location not found"})
  }
  if (results.length === 0) {
    return res.status(404).json({ message: 'Location not found.' });
  }

  res.status(200).json(results);
  
})
}

// controllers/locations.js
exports.getChildLocationsByParentName = (req, res) => {
  const db = req.db;
  const parentName = req.params.Pname;

  // Step 1: Fetch the parent location ID by name
  const selectParentQuery = 'SELECT locationId FROM locations WHERE locationName = ? AND parentid IS NULL';

  const parentValues = [parentName];

  db.query(selectParentQuery, parentValues, (err, parentResults) => {
    if (err) {
      console.error('Error retrieving parent location ID:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (parentResults.length === 0) {
      return res.status(404).json({ message: 'Parent location not found' });
    }

    const parentId = parentResults[0].locationId;

    // Step 2: Fetch all child locations by parent ID
    const selectChildQuery = 'SELECT * FROM locations WHERE parentid = ?';
    const childValues = [parentId];

    console.log("parentId:::",childValues,  parentId );

    db.query(selectChildQuery, childValues, (err, childResults) => {
      if (err) {
        console.error('Error retrieving child locations:', err);
        return res.status(500).json({ error: 'Internal Server Error' });
      }

      if (childResults.length === 0) {
        return res.status(404).json({ message: 'No child locations found for the parent' });
      }

      res.status(200).json(childResults);
    });
  });
};

// controllers/locations.js
exports.getParentLocations = (req, res) => {
  const db = req.db;

  const selectQuery = 'SELECT * FROM locations WHERE parentid IS NULL';

  db.query(selectQuery, (err, results) => {
    if (err) {
      console.error('Error retrieving parent locations:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (results.length === 0) {
      return res.status(404).json({ message: 'No parent locations found' });
    }

    res.status(200).json(results);
  });
};

exports.createLocation = (req, res) => {
  const { locationName, imageName, parentid } = req.body;

  if (!locationName) {
    return res.status(400).json({ error: 'Location name required' });
  }

  const db = req.db;
  const insertQuery = 'INSERT INTO locations (locationName, imageName, parentid) VALUES (?, ?, ?)';
  const values = [locationName, imageName, parentid || null];

  db.query(insertQuery, values, (err, result) => {
    if (err) {
      console.error('Error creating location:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }
    res.status(201).json({ message: 'Location created successfully', locationId: result.insertId });
  });
};

exports.editLocation = (req, res) => {
  const db = req.db;
  const locationId = req.params.id;
  const { locationName, orderby, imageName, parentid } = req.body;

  if (!locationName) {
    return res.status(400).json({ error: 'Location name required' });
  }

  const updateQuery = 'UPDATE locations SET locationName = ?, orderby = ?, imageName = ?, parentid = ? WHERE locationId = ?';
  const values = [locationName, orderby, imageName, parentid || null, locationId];

  db.query(updateQuery, values, (err, result) => {
    if (err) {
      console.error('Error editing location:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (result.affectedRows === 0) {
      return res.status(404).json({ message: 'Location not found.' });
    }
    res.status(200).json({ message: 'Location edited successfully' });
  });
};
 
exports.deleteLocation = (req, res) => {
  const db = req.db;
  const locationId = req.params.id;

  const deleteQuery = 'DELETE FROM locations WHERE locationId = ?';
  const values = [locationId];

  db.query(deleteQuery, values, (err, result) => {
    if (err) {
      console.error('Error deleting location:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (result.affectedRows === 0) {
      return res.status(404).json({ message: 'Location not found.' });
    }

    res.status(200).json({ message: 'Location deleted successfully' });
  });
};
