// controllers/landowner.js

exports.getReviews = (req, res) => {
  const db = req.db;
  const selectQuery = 'SELECT * FROM landowner';

  db.query(selectQuery, (err, results) => {
    if (results?.length === 0) {
      return res.status(404).json({ message: 'No data found.' });
    }
    if (err) {
      console.error('Error retrieving reviews:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    res.status(200).json(results);
  });
};

exports.getSingleReview = (req, res) => {
  const db = req.db;
  const reviewId = req.params.id;
  const selectQuery = 'SELECT * FROM landowner WHERE landownerid = ?';
  const values = [reviewId];

  db.query(selectQuery, values, (err, results) => {
    if (err) {
      console.error('Error retrieving review:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (results.length === 0) {
      return res.status(404).json({ message: 'review not found.' });
    }

    const reviews = results[0];
    res.status(200).json(reviews);
  });
};

exports.createReviews = (req, res) => {
  const { name, designation, comments, imageUrl} = req.body;

  if (!name) {
    return res.status(400).json({ error: 'name required' });
  }

  const db = req.db;
  const insertQuery = 'INSERT INTO landowner (name, designation, comments, imageUrl) VALUES (?, ?, ?, ?)';
  const values = [name, designation, comments, imageUrl];
  console.log("value::", values);
  db.query(insertQuery, values, (err, result) => {
    if (err) {
      console.error('Error creating review:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }
    res.status(201).json({ message: 'review created successfully', review: result });
  });
};

exports.editReviews = (req, res) => {
  const db = req.db;
  const clientReviewId = req.params.id;
  const { name, designation, comments, imageUrl } = req.body;

  if (!name) {
      return res.status(400).json({ error: 'Clinets name required' });
  }

  const updateQuery = 'UPDATE landowner SET name = ?, designation = ?, comments = ?, imageUrl = ? WHERE landownerid = ?';
  const values = [name, designation, comments, imageUrl, clientReviewId];

  db.query(updateQuery, values, (err, result) => {
      if (err) {
          console.error('Error editing review:', err);
          return res.status(500).json({ error: 'Internal Server Error' });
      }

      if (result.affectedRows === 0) {
          return res.status(404).json({ message: 'review not found.' });
      }
      res.status(200).json({ message: 'review edited successfully' });
  });
};
 
exports.deleteReviews = (req, res) => {
  const db = req.db;
  const clientReivewid = req.params.id;

  const deleteQuery = 'DELETE FROM landowner WHERE landownerid = ?';
  const values = [clientReivewid];

  db.query(deleteQuery, values, (err, result) => {
    if (err) {
      console.error('Error deleting review:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (result.affectedRows === 0) {
      return res.status(404).json({ message: 'review not found.' });
    }

    res.status(200).json({ message: 'review deleted successfully' });
  });
};



