const Category = require("../models/category");
const Item = require("../models/item");

/* --------------------------All GET Requests--------------------------- */

exports.getItems = async (req, res) => {
  try {
    // Find Drinks Menu
    let items = await Item.find({})
      .populate({ path: "availability.outlet", select: "_id name" })
      .populate({
        path: "category",
        select: "_id name",
      })
      .populate({
        path: "subCategory",
        select: "_id name",
      })
      .exec();
    return res.json(items);
  } catch (error) {
    console.log(error);
    return res.status(400).send("Error: 'getItems', Try Again!");
  }
};

exports.getItembyID = async (req, res) => {
  const itemId = req.params.id;
  try {
    // Find Drinks Menu
    let item = await Item.findOne({ _id: itemId })
      .populate({
        path: "category",
        select: "_id name",
      })
      .populate({
        path: "subCategory",
        select: "_id name",
      })
      .populate({ path: "availability.outlet", select: "_id name" })
      .exec();

    return res.json(item);
  } catch (error) {
    console.log(error);
    return res.status(400).send("Error: 'getItems', Try Again!");
  }
};

exports.getFeaturedItemsByOutletID = async (req, res) => {
  try {
    // Find Drinks Menu
    let featured = await Item.find({
      featured: true,
      outlet: { $in: req.params.outletID },
    }).exec();
    return res.json(featured);
  } catch (error) {
    console.log(error);
    return res.status(400).send("Error: 'getFeatured', Try Again!");
  }
};

/* --------------------------All POST Requests--------------------------- */

exports.addItem = async (req, res) => {
  try {
    const {
      name,
      category,
      subCategory,
      variation,
      details,
      imgUrl,
      remark,
      popularItem,
      itemClass,
      preparationTime,
      badge,
      outlet,
      time,
      available,
      availability,
      featured,
      whatsNew,
    } = req.body;
    // Validation
    if (!name) return res.status(400).send("Item Name is required!");
    if (!category) return res.status(400).send("Category _id is required!");
    if (!subCategory)
      return res.status(400).send("subCategory _id is required!");

    // Find if Item already exists in DB
    let itemExists = await Item.findOne({ name }).exec();

    if (itemExists) {
      return res.status(400).send("The Item already exists.");
    }

    if (category) {
      // Find parent Category in DB
      let parentCategory = await Category.findOne({ _id: subCategory }).exec();

      if (!parentCategory) {
        return res
          .status(400)
          .send("The Category does not exist. Please choose another one");
      } else {
        const item = await new Item({
          name: name,
          category: category,
          subCategory: subCategory,
          variation: variation,
          details: details,
          imgUrl: imgUrl,
          remark: remark,
          popularItem: popularItem,
          itemClass: itemClass,
          preparationTime: preparationTime,
          badge: badge,
          outlet: outlet,
          time: time,
          available: available,
          availability: availability,
          featured: featured,
          whatsNew: whatsNew,
        }).save();

        // Adding Item as child to parent category model
        parentCategory.childs.push(item);
        parentCategory.onModel = "Item";
        parentCategory.save();
        console.log("posted data item", item);
        return res.json({ ok: true });
      }
    }
  } catch (error) {
    console.log(error);
    return res.status(400).send("Error: 'addItem', Try Again!");
  }
};

/* --------------------------All UPDATE Requests--------------------------- */

exports.updateItem = async (req, res) => {
  // const { itemId } = req.params;
  const { _id } = req.body;
  console.log("req.body--------", req.body);
  try {
    const {
      name,
      category,
      subCategory,
      variation,
      details,
      imgUrl,
      remark,
      popularItem,
      itemClass,
      preparationTime,
      badge,
      outlet,
      time,
      available,
      availability,
      featured,
      whatsNew,
      posCategoryId,
      price,
    } = req.body;

    // Find the Item by ID
    //console.log("id test=>", _id)
    let item = Item.findById(_id).exec();

    if (!item) {
      return res.status(404).json({ error: "Item not found" });
    }

    // Update the Item fields
    item.name = name || item.name;
    item.subCategory = subCategory || item.subCategory;
    item.category = category || item.category;
    item.variation = variation || item.variation;
    item.details = details || item.details;
    item.imgUrl = imgUrl || item.imgUrl;
    item.remark = remark || item.remark;
    item.preparationTime = preparationTime || item.preparationTime;
    item.badge = badge || item.badge;
    item.outlet = outlet || item.outlet;
    item.time = time || item.time;
    item.availability = availability || item.availability;
    item.available = available || item.available;
    item.featured = featured || item.featured;
    item.whatsNew = whatsNew || item.whatsNew;
    item.popularItem = popularItem || item.popularItem;
    item.itemClass = itemClass || item.itemClass;
    item.posCategoryId = posCategoryId || item.posCategoryId;
    item.price = price || item.price;

    if (imgUrl) {
      //   fs.unlink(`uploads/${image}`, function(err){
      //   if (err) console.log("No file found")
      //  })
      item.imgUrl = imgUrl;
    }

    // Save the updated Item
    console.log("Testing => ", item);
    // const updatedItem = item.save();
    Item.findOneAndUpdate(
      { _id: _id },
      {
        $set: item,
      },
      {
        new: true,
      }
    ).then((data) => {
      if (!data) {
        res.status(404).send({
          message: `Cannot update this item`,
        });
      } else return res.send({ message: "Successfully update: ", data });
    });
    // return res.json({ ok: true, item: updatedItem });
  } catch (error) {
    console.log(error);
    return res.status(400).send("Error: 'updateItem', Try Again!");
  }
};

// Function to update availability.avilable
exports.updateAvailabilityStatus = async (req, res) => {
  // console.log("req.body for availble put", req.body)
  try {
    const { itemId, outletId, available } = req.body;
    console.log("available=>", available);
    const updatedItem = await Item.findOneAndUpdate(
      {
        _id: itemId,
        "availability.outlet": outletId,
      },
      {
        $set: { "availability.$.available": available },
      },
      { new: true }
    );

    if (!updatedItem) {
      // Item not found or outlet not found in availability array
      throw new Error("Item or outlet not found");
    }
    return res.status(200).send("available Updated");
    e;
    // console.log('Item availability updated:', updatedItem.availability);
  } catch (error) {
    console.error("Error updating item availability status:", error);
    return res.status(400).send("Error occured to updated");
  }
};

/* --------------------------All DELETE Requests--------------------------- */

exports.deleteItem = async (req, res) => {
  try {
    const { _id } = req.body;

    // Validation
    if (!_id) return res.status(400).send("Item Name is required!");

    // Find if Item exists in DB
    const item = await Item.findOne({ _id: _id }).exec();

    if (item) {
      if (item.category) {
        // Find if Category
        let parentCategory = await Category.findOne({
          _id: item.category,
        }).exec();
        parentCategory.childs.pull(item);
        parentCategory.save();
      }
      //delete image
      if (item.imgUrl) {
        const res = await axios.delete(`/images/delete/${item.imgUrl}
        `);
        console.log(res);
      }

      await Item.deleteOne({ _id: item._id });
    } else {
      console.log(error);
      return res.status(400).send("Item doesn't exist in database!");
    }

    return res.json({ ok: true });
  } catch (error) {
    console.log(error);
    return res.status(400).send("Error: 'deleteItem', Try Again!");
  }
};
