const multer = require("multer");
const fs = require("fs");
const { CLIENT_RENEG_LIMIT } = require("tls");

const createImage = (req, res) => {
  // Define storage configuration for multer
  const storage = multer.diskStorage({
    destination: (req, file, cb) => {
      cb(null, "uploads");
    },
    filename: (req, file, cb) => {
      cb(null, file.originalname);
    },
  });

  // Initialize multer with the defined storage configuration 
  const upload = multer({ storage: storage });

  // Middleware function to handle file uploads
 const filesUpload = upload.fields([{ name: 'image', maxCount: 7 }, { name: 'pdf', maxCount: 1 }]); 

  // Check if files were uploaded successfully
  filesUpload(req, res, (err) => {
    if (err) {
      console.error("Error uploading files:", err);
      return res.status(500).json({ error: "Error uploading files" });
    }

    // Check if files were actually uploaded
    if (!req.files || Object.keys(req.files).length === 0) {
      console.log("No files were uploaded.");
      return res.status(400).json({ message: "No files were uploaded" });
    }

    // If files were uploaded, send success response
    console.log("Files uploaded successfully");
    return res.status(200).json({ message: "Files uploaded successfully" });
  });
};

const getImage = (req, res) => {
  // Implement logic to get a single image
  console.log("params=<<>>", req.params.id)
  const filename = req.params.id;
  const filePath = `./uploads/${filename}`;

  fs.readFile(filePath, (err, data) => {
    if (err) {
      console.log(err);
      res.status(404).send("Image not found");
    } else {
      res.writeHead(200, { "Content-Type": "image/jpeg" });
      res.end(data);
    }
  });
};

const deleteImage = (req, res) => {
  // Implement logic to delete an image
  const filename = req.params.filename;
  console.log("filename:::", filename)
  const filePath = `./uploads/${filename}`;
  fs.unlink(filePath, (err) => {
    if (err) {
      console.log(err);
      res.status(400).json({ error: "Failed to delete file" });
    } else {
      res.status(200).json({ message: "File deleted" });
    }
  });
};

module.exports = {
  getImage,
  createImage,
  deleteImage,
};
