// controllers/homepage.js
exports.getHomePageData = (req, res) => {
  const db = req.db;
  const selectQuery = 'SELECT * FROM homepage';

  db.query(selectQuery, (err, results) => {
    if (err) {
      console.error('Error retrieving homepage data:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    // Handle both scenarios: no data and successful retrieval
    if (results.length === 0) {
      return res.status(200).json({ message: 'No homepage data found. You can create new data.' }); // 200 OK, indicating no data is normal
    } else {
      // Parse JSON strings in results
      const parsedResults = results.map(row => ({
        ...row,
        slider: JSON.parse(row.slider),
        offerProject: JSON.parse(row.offerProject),
        gallery: JSON.parse(row.gallery),
        bench_marks: JSON.parse(row.bench_marks)
      }));
      return res.status(200).json(parsedResults); // 200 OK with the data
    }
  });
};

exports.createHomePageData = (req, res) => {
  const { slider, offerProject, YtVideoUrl, offerLine, gallery, tag_line, bench_marks } = req.body;

  const db = req.db;
  const insertQuery = 'INSERT INTO homepage (slider, offerProject, YtVideoUrl, offerLine, gallery) VALUES (?, ?, ?, ?, ?)';
  const values = [
    JSON.stringify(slider),
    JSON.stringify(offerProject),
    YtVideoUrl,
    tag_line,
    JSON.stringify(offerLine),
    JSON.stringify(gallery),
    JSON.stringify(bench_marks)
  ]; // Stringify JSON data

  db.query(insertQuery, values, (err, result) => {
    if (err) {
      console.error('Error creating homepage data:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }
    res.status(201).json({ message: 'Homepage data created successfully', insertId: result.insertId }); // Include insertId
  });
};

exports.editHomePageData = (req, res) => {
  const db = req.db;
  const { slider, offerProject, YtVideoUrl, tag_line, bench_marks, gallery } = req.body;

  // Assuming there's only one row in the homepage table (single homepage configuration)
  const updateQuery = 'UPDATE homepage SET slider = ?, offerProject = ?, YtVideoUrl = ?, gallery = ?, tag_line = ?, bench_marks = ?';
  const values = [JSON.stringify(slider), JSON.stringify(offerProject), YtVideoUrl, JSON.stringify(gallery), tag_line, JSON.stringify(bench_marks)];

  db.query(updateQuery, values, (err, result) => {
    if (err) {
      console.error('Error editing homepage data:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (result.affectedRows === 0) {
      return res.status(404).json({ message: 'Homepage data not found.' });
    }
    res.status(200).json({ message: 'Homepage data edited successfully' });
  });
};