// controllers/green.js
exports.getGreen = (req, res) => {
  const db = req.db;
  const selectQuery = 'SELECT * FROM green';

  db.query(selectQuery, (err, results) => {
    if (results?.length === 0) {
      return res.status(404).json({ message: 'No data found.' });
    }
    if (err) {
      console.error('Error retrieving green concepts:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    res.status(200).json(results);
  });
};


exports.getSingleGreen = (req, res) => {
  const db = req.db;
  const greenId = req.params.id;
  const selectQuery = 'SELECT * FROM green WHERE id = ?';
  const values = [greenId];

  db.query(selectQuery, values, (err, results) => {
    if (err) {
      console.error('Error retrieving green practice:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (results.length === 0) {
      return res.status(404).json({ message: 'Green Practice not found.' });
    }

    const reviews = results[0];
    res.status(200).json(reviews);
  });
};


exports.createGreen = (req, res) => {
  const { title, desciption, benefits } = req.body;

  if (!title) {
    return res.status(400).json({ error: 'green Title required' });
  }

  const db = req.db;
  const insertQuery = 'INSERT INTO green (title, desciption, benefits) VALUES (?, ?, ?)';
  const values = [title, desciption, benefits];
console.log("value::", values);
  db.query(insertQuery, values, (err, result) => {
    if (err) {
      console.error('Error creating green:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }
    res.status(201).json({ message: 'green created successfully', green: result.insertId });
  });
};

exports.editGreen = (req, res) => {
  const db = req.db;
  const greenId = req.params.id;
  const {title, desciption, benefits } = req.body;

  if (!title) {
      return res.status(400).json({ error: 'green preactice name required' });
  }

  const updateQuery = 'UPDATE green SET title = ?, desciption = ?, benefits = ? WHERE id = ?';
  const values = [title, desciption,benefits, greenId];

  db.query(updateQuery, values, (err, result) => {
      if (err) {
          console.error('Error editing green:', err);
          return res.status(500).json({ error: 'Internal Server Error' });
      }

      if (result.affectedRows === 0) {
          return res.status(404).json({ message: 'green not found.' });
      }
      res.status(200).json({ message: 'green edited successfully' });
  });
};
 
exports.deleteGreen = (req, res) => {
  const db = req.db;
  const greenId = req.params.id;

  const deleteQuery = 'DELETE FROM green WHERE id = ?';
  const values = [greenId];

  db.query(deleteQuery, values, (err, result) => {
    if (err) {
      console.error('Error deleting green:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (result.affectedRows === 0) {
      return res.status(404).json({ message: 'green not found.' });
    }

    res.status(200).json({ message: 'green deleted successfully' });
  });
};

