// controllers/directors.js
exports.getDirectors = (req, res) => {
  const db = req.db;
  const selectQuery = 'SELECT * FROM directors';

  db.query(selectQuery, (err, results) => {
    if (results?.length === 0) {
      return res.status(404).json({ message: 'No data found.' });
    }
    if (err) {
      console.error('Error retrieving directors:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    res.status(200).json(results);
  });
};

exports.getSingleDirectors = (req, res) => {
  const db = req.db;
  const directorId = req.params.id;
  const selectQuery = 'SELECT * FROM directors WHERE id = ?';
  const values = [directorId];

  db.query(selectQuery, values, (err, results) => {
    if (err) {
      console.error('Error retrieving directors:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (results.length === 0) {
      return res.status(404).json({ message: 'directors not found.' });
    }

    const director = results[0];
    res.status(200).json(director);
  });
};

exports.createDirectors = (req, res) => {
  const { name, role, description, imgUrl } = req.body;

  if (!name) {
    return res.status(400).json({ error: 'Director Name required' });
  }

  const db = req.db;
  const insertQuery = 'INSERT INTO directors (name, role, description, imgUrl) VALUES (?, ?, ?, ?)';
  const values = [name, role, description, imgUrl];
console.log("value::", values);
  db.query(insertQuery, values, (err, result) => {
    if (err) {
      console.error('Error creating director:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }
    res.status(201).json({ message: 'director created successfully', directors: result.insertId });
  });
};

exports.editDirectors = (req, res) => {
  const db = req.db;
  const directorId = req.params.id;
  const { name, role, description, imgUrl} = req.body;


  const updateQuery = 'UPDATE directors SET name = ?, role = ?, description = ?, imgUrl = ? WHERE id = ?';
  const values = [name, role, description, imgUrl, directorId];

  db.query(updateQuery, values, (err, result) => {
      if (err) {
          console.error('Error editing director:', err);
          return res.status(500).json({ error: 'Internal Server Error' });
      }

      if (result.affectedRows === 0) {
          return res.status(404).json({ message: 'director not found.' });
      }
      res.status(200).json({ message: 'director edited successfully' });
  });
};
 
exports.deleteDirectors = (req, res) => {
  const db = req.db;
  const directorId = req.params.id;

  const deleteQuery = 'DELETE FROM directors WHERE id = ?';
  const values = [directorId];

  db.query(deleteQuery, values, (err, result) => {
    if (err) {
      console.error('Error deleting director:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (result.affectedRows === 0) {
      return res.status(404).json({ message: 'director not found.' });
    }

    res.status(200).json({ message: 'director deleted successfully' });
  });
};

