// controllers/csrgallery.js
exports.getCsrGallery = (req, res) => {
  const db = req.db;
  const selectQuery = 'SELECT * FROM csrgallery';

  db.query(selectQuery, (err, results) => {
    if (results?.length === 0) {
      return res.status(404).json({ message: 'No data found.' });
    }

    if (err) {
      console.error('Error retrieving csrgallery:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    // const parsedResult = results.map(n => {
    //   n.imageUrls = JSON.parse(n.imageUrls)
    //   return n;
    // })

    res.status(200).json(results);
  });
};

exports.getSingleCsrGallery = (req, res) => {
  const db = req.db;
  const csrgalleryId = req.params.id;
  const selectQuery = 'SELECT * FROM csrgallery WHERE id = ?';
  const values = [csrgalleryId];

  db.query(selectQuery, values, (err, results) => {
    if (err) {
      console.error('Error retrieving csrgallery:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (results.length === 0) {
      return res.status(404).json({ message: 'csrgallery not found.' });
    }

    // const parsedResult = results.map(n => {
    //   n.imageUrls = JSON.parse(n.imageUrls)
    //   return n;
    // })

    // const csrgallery = parsedResult[0];
    res.status(200).json(results);
  });
};

exports.createCsrGallery = (req, res) => {
  const {title, imgUrl, description} = req.body;

  if (!title) {
    return res.status(400).json({ error: 'csrgallery Title required' });
  }

  const db = req.db;
  const insertQuery = 'INSERT INTO csrgallery (title, imgUrl, description) VALUES (?, ?, ?)';
  const values = [
    title,
    imgUrl,
    description,
  ];
  console.log("value::", values);
  db.query(insertQuery, values, (err, result) => {
    if (err) {
      console.error('Error creating csrgallery:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }
    res.status(201).json({ message: 'csrgallery created successfully', csrgallery: result.insertId });
  });
};

exports.editCsrGallery = (req, res) => {
  const db = req.db;
  const id = req.params.id;
  const { title, imgUrl, description } = req.body;

  if (!title) {
    return res.status(400).json({ error: 'Location name required' });
  }

  const updateQuery = 'UPDATE csrgallery SET title = ?, imgUrl = ?, description = ? WHERE id = ?';
  const values = [title, imgUrl, description, id];

  db.query(updateQuery, values, (err, result) => {
    if (err) {
      console.error('Error editing csrgallery:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (result.affectedRows === 0) {
      return res.status(404).json({ message: 'csrgallery not found.' });
    }
    res.status(200).json({ message: 'csrgallery edited successfully' });
  });
};

exports.deleteCsrGallery = (req, res) => {
  const db = req.db;
  const id = req.params.id;

  const deleteQuery = 'DELETE FROM csrgallery WHERE id = ?';
  const values = [id];

  db.query(deleteQuery, values, (err, result) => {
    if (err) {
      console.error('Error deleting csrgallery:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (result.affectedRows === 0) {
      return res.status(404).json({ message: 'csrgallery not found.' });
    }

    res.status(200).json({ message: 'csrgallery deleted successfully' });
  });
};

