// controllers/otherinfo.js
exports.getCSR = (req, res) => {
  const db = req.db;
  const selectQuery = 'SELECT * FROM csr';

  db.query(selectQuery, (err, results) => {
    if (results?.length === 0) {
      return res.status(404).json({ message: 'No csr data found. 0' });
    }
    if (err) {
      console.error('Error retrieving csr:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    // Parse JSON fields (ourstory in this case)
    const parsedResult = results.map(row => {
      try {
        row.pillars = JSON.parse(row.pillars);
      } catch (parseError) {
        console.error('Error parsing ourstory:', parseError);
        row.ourstory = []; // Or a default value if parsing fails
      }
      return row;
    });

    res.status(200).json(parsedResult[0]); // Since it's a single row, send the first item
  });
};

exports.createCSR = (req, res) => {
  const db = req.db;
  const {
    title, description, glimpse, glimpseimg, csrMission, csrVission,
    post1img, post1text, post2text, post2img, post3text, post3img, pillars,
  } = req.body;

  try {
    // Convert pillars to JSON string for storage (if necessary)
    const pillarsJson = JSON.stringify(pillars);

    const insertQuery = `
      INSERT INTO csr (
        title, description, glimpse, glimpseimg, csrMission, csrVission,
        post1img, post1text, post2text, post2img, post3text, post3img, pillars
      )
      VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    `;

    const values = [
      title, description, glimpse, glimpseimg, csrMission, csrVission,
      post1img, post1text, post2text, post2img, post3text, post3img, pillarsJson
    ];

    const result = db.query(insertQuery, values);

    res.status(201).json({ message: 'CSR created successfully', csrId: result.insertId });
  } catch (err) {
    console.error('Error creating CSR:', err);
    res.status(500).json({ error: 'Internal Server Error' });
  }
};

exports.updateCSR = (req, res) => {
  const db = req.db;
  const {
    title, description, glimpse, glimpseimg, csrMission, csrVission, post1img, post1text, post2text, post2img, post3text, post3img,  pillars,
  } = req.body;

  
  const updateQuery = `
      UPDATE csr 
      SET 
        title = ?,
        description = ?,
        glimpse = ? , 
        glimpseimg = ?,
        csrMission = ?,
        csrVission = ?,
        post1text = ?,
        post1img = ?, 
        post2text = ?, 
        post2img = ?,
        post3text = ?, 
        post3img = ?, 
        pillars = ?
    `;

  const values = [
    title,    
    description,
    glimpse, 
    glimpseimg,
    csrMission,
    csrVission,
    post1text,
    post1img, 
    post2text, 
    post2img,
    post3text, 
    post3img,
    JSON.stringify(pillars)
  ];

  db.query(updateQuery, values, (err, result) => {
    if (err) {
      console.error('Error updating csr Page data:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }
    res.status(200).json({ message: 'CSR page data updated successfully' });
  });
};

// controllers/otherinfo.js (continued...)

