const nodemailer = require('nodemailer');


exports.deleteContactInfo = (req, res) => {
    const db = req.db;

    // Construct the DELETE query
    const deleteQuery = 'DELETE FROM contacts_info';

    // Execute the DELETE query
    db.query(deleteQuery, (err, result) => {
        if (err) {
            console.error('Error deleting contact info:', err);
            return res.status(500).json({ error: 'Internal Server Error' });
        }

        res.status(200).json({ message: 'All contact information deleted successfully' });
    });
};

exports.getContactInfo = (req, res) => {
    const db = req.db;

    // Construct the SELECT query
    const selectQuery = 'SELECT * FROM contacts_info';

    // Execute the SELECT query
    db.query(selectQuery, (err, result) => {
        if (err) {
            console.error('Error fetching contact info:', err);
            return res.status(500).json({ error: 'Internal Server Error' });
        }

        if (result.length === 0) {
            return res.status(404).json({ message: 'No contact information found.' });
        }

        const contactInfo = result[0]; // Assuming there's only one record in the table

        // Parse JSON strings into JavaScript objects
        const parsedContactInfo = {
            chittagong_office: JSON.parse(contactInfo.chittagong_office),
            corporate_office: JSON.parse(contactInfo.corporate_office),
            contact: JSON.parse(contactInfo.contact),
            received_email: contactInfo.received_email,
            social_links: JSON.parse(contactInfo.social_links),
            location_map: JSON.parse(contactInfo.location_map)
        };

        // Remove any JSON fields that should not be exposed
        delete parsedContactInfo.id; // Assuming 'id' is an auto-increment primary key

        res.status(200).json(parsedContactInfo);
    });
};

exports.createContactInfo = (req, res) => {
    const db = req.db;
    const { chittagong_office, corporate_office, contact, received_email, social_links, location_map } = req.body;

    // Validate required fields
    if (!chittagong_office || !corporate_office || !contact || !received_email || !social_links || !location_map) {
        return res.status(400).json({ error: 'All fields are required' });
    }

    // Construct the INSERT query
    const insertQuery = 'INSERT INTO contacts_info (chittagong_office, corporate_office, contact, received_email, social_links, location_map) VALUES (?, ?, ?, ?, ?, ?)';
    const values = [JSON.stringify(chittagong_office), JSON.stringify(corporate_office), JSON.stringify(contact), received_email, JSON.stringify(social_links), JSON.stringify(location_map)];

    // Execute the INSERT query
    db.query(insertQuery, values, (err, result) => {
        if (err) {
            console.error('Error creating contact info:', err);
            return res.status(500).json({ error: 'Internal Server Error' });
        }

        res.status(201).json({ message: 'Contact information created successfully' });
    });
};

exports.editContactInfo = (req, res) => {
    const db = req.db;
    const { chittagong_office, corporate_office, contact, received_email, social_links, location_map } = req.body;

    // Validate if at least one field is provided for update
    if (!chittagong_office && !corporate_office && !contact && !received_email && !social_links && !location_map) {
        return res.status(400).json({ error: 'At least one field required for update' });
    }

    // Construct the UPDATE query based on provided fields
    let updateQuery = 'UPDATE contacts_info SET ';
    let values = [];

    if (chittagong_office) {
        updateQuery += 'chittagong_office = ?, ';
        values.push(JSON.stringify(chittagong_office));
    }

    if (corporate_office) {
        updateQuery += 'corporate_office = ?, ';
        values.push(JSON.stringify(corporate_office));
    }

    if (contact) {
        updateQuery += 'contact = ?, ';
        values.push(JSON.stringify(contact));
    }

    if (received_email) {
        updateQuery += 'received_email = ?, ';
        values.push(received_email);
    }

    if (social_links) {
        updateQuery += 'social_links = ?, ';
        values.push(JSON.stringify(social_links));
    }

    if (location_map) {
        updateQuery += 'location_map = ?, ';
        values.push(JSON.stringify(location_map));
    }

    // Remove the trailing comma and space from the updateQuery
    updateQuery = updateQuery.slice(0, -2);

    console.log("values::", values);
    // Execute the UPDATE query
    db.query(updateQuery, values, (err, result) => {
        if (err) {
            console.error('Error editing contact info:', err);
            return res.status(500).json({ error: 'Internal Server Error' });
        }

        if (result.affectedRows === 0) {
            return res.status(404).json({ message: 'No contact information found to update.' });
        }

        res.status(200).json({ message: 'Contact information updated successfully' });
    });
};

exports.sendEmail = (req, res) => {
    const db = req.db;
    const { name, phone, email, queryFor, message } = req.body;


    // insert data into database 
    const insertQuery = 'INSERT INTO formdata (name, phone, email, queryFor, message) VALUES (?, ?, ?, ?, ?)';

    const values =  [name, phone, email, queryFor, message]
console.log("Values:::", values);
    db.query(insertQuery, values, (err, result) => {
        if (err) {
            console.log(err);
            return res.status(500).json({ error: 'Internal Server Error' });
        }
    })


    // Construct the SELECT query to fetch the received_email
    const selectQuery = 'SELECT received_email FROM contacts_info';

    // Execute the SELECT query
    db.query(selectQuery, (error, results) => {
        if (error) {
            console.error('Error occurred while fetching received_email:', error);
            res.status(500).json({ error: 'An error occurred while fetching received_email.' });
            return;
        }
        // Extract the received_email from the query results
        const receivedEmail = results[0].received_email;
        console.log("email::::", receivedEmail);

        // Destructure the required information from the request body
        

        // Create a transporter using nodemailer
        const transporter = nodemailer.createTransport({
            service: 'Gmail',
            host: 'smtp.gmail.com',
            port: 465,
            // port: 587,
            secure: true, // true for 465, false for other ports
            auth: {
                user: process.env.USER_EMAIL, // Sender's email
                pass: process.env.USER_EMAIL_PASS, // Sender's password or app password
            },
        });

        // Construct email options
        const mailOptions = {
            from: process.env.USER_EMAIL, // Sender address
            to: receivedEmail, // Receiver address fetched from the database
            subject: 'Website New Inquiry', // Email subject
            html: `
          <p><strong>Name:</strong> ${name ? name : ""}</p>
          <p><strong>Phone:</strong> ${phone ? phone : ""}</p>
          <p><strong>Email:</strong> ${email ? email : ""}</p>
          <p><strong>Query For:</strong> ${queryFor ? queryFor : ""}</p>
          <p><strong>Message:</strong> ${message ? message : ""}</p>
        `,
        };

        // Send email
        transporter.sendMail(mailOptions, (error, info) => {
            if (error) {
                console.error('Error occurred while sending email:', error);
                res.status(400).json({ error: 'An error occurred while sending the email.', details: error });
            } else {
                console.log('Email sent:', info.response);
                res.status(200).json({ message: 'Email sent successfully.' });
            }
        });
    });
};

exports.getFromData = (req, res) => {
    const db = req.db;

    // Construct the SELECT query
    const selectQuery = 'SELECT * FROM formdata ORDER BY id DESC';

    // Execute the SELECT query
    db.query(selectQuery, (err, result) => {
        if (err) {
            console.error('Error fetching contact info:', err);
            return res.status(500).json({ error: 'Internal Server Error' });
        }

        if (result.length === 0) {
            return res.status(404).json({ message: 'No contact information found.' });
        }

        res.status(200).json(result);
    });
};

exports.deleteSingleFormData = (req, res) => {
    const db = req.db;
    const formDataId = req.params.id;
  
    const deleteQuery = 'DELETE FROM formdata WHERE id = ?';
    const values = [formDataId];
  
    db.query(deleteQuery, values, (err, result) => {
      if (err) {
        console.error('Error deleting form data:', err);
        return res.status(500).json({ error: 'Internal Server Error' });
      }
  
      if (result.affectedRows === 0) {
        return res.status(404).json({ message: 'Form Data not found.' });
      }
  
      res.status(200).json({ message: 'Form Datea deleted successfully' });
    });
  };
  