// controllers/clients.js
exports.getClients = (req, res) => {
  const db = req.db;
  const selectQuery = 'SELECT * FROM clients';

  db.query(selectQuery, (err, results) => {
    if (results?.length === 0) {
      return res.status(404).json({ message: 'No data found.' });
    }
    
    if (err) {
      console.error('Error retrieving clients:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    res.status(200).json(results);
  });
};

exports.getSingleClient = (req, res) => {
  const db = req.db;
  const clientId = req.params.id;
  const selectQuery = 'SELECT * FROM clients WHERE id = ?';
  const values = [clientId];

  db.query(selectQuery, values, (err, results) => {
    if (err) {
      console.error('Error retrieving clients:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (results.length === 0) {
      return res.status(404).json({ message: 'clients not found.' });
    }

    const client = results[0];
    res.status(200).json(client);
  });
};

exports.createClient = (req, res) => {
  const { name, imgUrl } = req.body;

  if (!name) {
    return res.status(400).json({ error: 'client Title required' });
  }

  const db = req.db;
  const insertQuery = 'INSERT INTO clients (name, imgUrl) VALUES (?, ?)';
  const values = [name, imgUrl];
console.log("value::", values);
  db.query(insertQuery, values, (err, result) => {
    if (err) {
      console.error('Error creating client:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }
    res.status(201).json({ message: 'client created successfully', client: result.insertId });
  });
};

exports.editClient = (req, res) => {
  const db = req.db;
  const clientId = req.params.id;
  const { name, imgUrl } = req.body;


  const updateQuery = 'UPDATE clients SET name = ?, imgUrl = ? WHERE id = ?';
  const values = [name, imgUrl, clientId];

  db.query(updateQuery, values, (err, result) => {
      if (err) {
          console.error('Error editing client:', err);
          return res.status(500).json({ error: 'Internal Server Error' });
      }

      if (result.affectedRows === 0) {
          return res.status(404).json({ message: 'client not found.' });
      }
      res.status(200).json({ message: 'client edited successfully' });
  });
};
 
exports.deleteClient = (req, res) => {
  const db = req.db;
  const clientId = req.params.id;

  const deleteQuery = 'DELETE FROM clients WHERE id = ?';
  const values = [clientId];

  db.query(deleteQuery, values, (err, result) => {
    if (err) {
      console.error('Error deleting client:', err);
      return res.status(500).json({ error: 'Internal Server Error' });
    }

    if (result.affectedRows === 0) {
      return res.status(404).json({ message: 'cleint not found.' });
    }

    res.status(200).json({ message: 'client deleted successfully' });
  });
};

