const Category = require("../models/category");

const { DateTime } = require("luxon");

/* --------------------------All GET Requests--------------------------- */

exports.getCategories = async (req, res) => {
  try {
    // Find Categories
    let categories = await Category.find({ parent: null }).exec();
    return res.json(categories);
  } catch (error) {
    console.log(error);
    return res.status(400).send("Error: 'getCategories', Try Again!");
  }
};

exports.getCategoryById = async (req, res) => {
  try {
    // Find Categories
    let categories = await Category.findOne({ _id: req.params.id }).exec();
    return res.json(categories);
  } catch (error) {
    console.log(error);
    return res.status(400).send("Error: 'getCategories', Try Again!");
  }
};

exports.getSubCategories = async (req, res) => {
  try {
    // Find Categories
    let categories = await Category.find({ parent: { $ne: null } }).exec();
    return res.json(categories);
  } catch (error) {
    console.log(error);
    return res.status(400).send("Error: 'getCategories', Try Again!");
  }
};

/* --------------------------All POST Requests--------------------------- */

exports.addCategory = async (req, res) => {
  try {
    const { sn, name, parent, childs, remark, availability } = req.body;

    // Validation
    if (!name) return res.status(400).send("Category Name is required!");

    // Find if Category already exists in DB
    let categoryExists = await Category.findOne({ name: name }).exec();

    if (categoryExists) {
      return res.status(400).send("Category already exists.");
    }

    if (parent) {
      // Find parent in DB
      let parentCategory = await Category.findOne({ _id: parent }).exec();

      if (!parentCategory) {
        return res.status(400).send("Parent category does not exist.");
      } else {
        // ConvertStart and End times to Seconds format.
        // const startTime = DateTime.fromFormat(start, "HH:mm").toSeconds();
        // const endTime = DateTime.fromFormat(end, "HH:mm").toSeconds();

        const category = await new Category({
          name: name,
          parent: parentCategory,
          childs: [],
          remark: remark,
          availability: availability,
        }).save();

        // Adding Subcategory as a child to parent Category model
        parentCategory.childs.push(category);
        parentCategory.onModel = "Category";
        parentCategory.save();
      }
    } else {
      // const startTime = DateTime.fromFormat(start, "HH:mm").toSeconds();
      // const endTime = DateTime.fromFormat(end, "HH:mm").toSeconds();

      const category = await new Category({
        name: name,
        childs: [],
        remark: remark,
        availability: availability,
      }).save();
    }

    return res.json({ ok: true });
  } catch (error) {
    console.log(error);
    return res.status(400).send("Error: 'addCategory', Try Again!");
  }
};

/* --------------------------All UPDATE Requests--------------------------- */

exports.updateCategory = (req, res) => {
  try {
    const { _id } = req.body;

    // Validation
    if (!_id) return res.status(400).send("Category Name is required!");

    // ConvertStart and End times to Seconds format.
    // const startTime = DateTime.fromFormat(start, "HH:mm").toSeconds();
    // const endTime = DateTime.fromFormat(end, "HH:mm").toSeconds();

    Category.findOneAndUpdate(
      { _id: _id },
      req.body,
      { new: true },
      (error, updatedRecord) => {
        if (error) {
          return res.status(400).send("Error: Category doesn't exist!");
        } else {
          return res.json(updatedRecord);
        }
      }
    );
  } catch (error) {
    console.log(error);
    return res.status(400).send("Error: 'updateCategory', Try Again!");
  }
};

/* --------------------------All DELETE Requests--------------------------- */

exports.deleteCategory = async (req, res) => {
  try {
    const { _id } = req.body;

    // Validation
    if (!_id) return res.status(400).send("Category Name is required!");

    // Find if Category exists in DB
    const category = await Category.findOne({ _id: _id }).exec();

    if (category) {
      if (category.parent) {
        // Find if Category
        let parentCategory = await Category.findOne({
          _id: category.parent,
        }).exec();
        parentCategory.childs.pull(category);
        parentCategory.save();
      }

      await Category.deleteOne({ _id: category._id });
      return res.json({ ok: true });
    } else {
      console.log(error);
      return res.status(400).send("Error, Try Again!");
    }
  } catch (error) {
    console.log(error);
    return res.status(400).send("Error: 'deleteCategory', Try Again!");
  }
};
